
#include "MAIN.h"
#include "IO.h"
#include <math.h>


//#define UNDERLAP 20	//20 equals 1 usecond

  //   #define Ts   5.5e-5                  // Sampling frequency 18181.81818Hz
  //   #define SwitchPeriod 4125         // 55us, GPTA0 clock frequency is 75M

   //#define Ts   6.66666666667e-5                  // Sampling period 67us
   //#define SwitchPeriod 5000         // 67us, GPTA0 clock frequency is 75M

   #define Ts   6e-5                  // Sampling period 6us
   #define SwitchPeriod 4500         // 6us, GPTA0 clock frequency is 75M

   //#define Ts   2e-4                  //2e-4,Sampling period 200us
   //#define SwitchPeriod 15000   //200us, GPTA0 clock frequency is 75M

   #define pi 3.14159265359
   #define a  1.25663706143    //2*pi/5, used in stationary frame transformation
  
      // #define DeadBand 99         //2.65us
   #define DeadBand 150         // 2us	//2-level
  // #define DeadBand 188         // 2.65us  3-level 

   #define InitialBand 200      // 1.33us      
   #define CurrentFactor 0.005713929521 // (Vreal-Vdcoffset)/4096*3.3/47*1000/3 
   #define WrScale 2*pi/1024/0.005
   #define T_temp  10   //	133ns
   				        		  //Fluxing current
   #define FluxRef  0.4          //IdseRef/sqrt(2)=2.7Arms
   								  //integrator limitation
   #define Torquemax      10.5
   #define Torquemin     -10.5
   #define SpeedErrStmax  10.5
   #define SpeedErrStmin -10.5

   #define FluxErrStmax   0.525648936*Vdc*0.85   // 0.665*Vdc is the vector length for m=0.8
   #define FluxErrStmin   -0.525648936*Vdc*0.85
   #define TorqueErrStmax 0.525648936*Vdc*0.85
   #define TorqueErrStmin  -0.525648936*Vdc*0.85

   #define IdseErrStmax   0.525648936*Vdc*0.85
   #define IdseErrStmin  -0.525648936*Vdc*0.85
   #define IqseErrStmax   0.525648936*Vdc*0.85
   #define IqseErrStmin  -0.525648936*Vdc*0.85
   
   #define Iqsemax  10.5      //Iqsemax/sqrt(2) is the maximum
   #define Iqsemin -10.5      //phase torque current,7.5Arms.
   #define Vdsemax  0.525648936*Vdc*0.85   //0.525648936*Vdc is the vector length for
   #define Vdsemin -0.525648936*Vdc*0.85    //modulation index=1.0
   
   
   #define VdseMax  0.525648936*Vdc*0.85    //0.525648936*Vdc is the vector length for
   #define VdseMin -0.525648936*Vdc*0.85    //modulation index=1.0 

   #define Kit       0.085// 0.085//   0.085 // 0.15  
   #define Kpt       1// 1//   1  //1.2            
   #define Kif       2// 2 // 1 //2 //   0.6 //1.2
   #define Kpf       25// 25//10 //25  //   6.0 //12

  
   #define Kispd    0.003125// 0.0038// 0.0038//0.0038// 0.003125// 0.003125//0.00625//0.0625// 0.00625 // it is very important to use the correct Ki or Kp, previousely
                              // the Ki and Kp is very so big that as soon as the rotor speed is
                             //  reach the reference speed, the system will be instable when the DC link voltage goes up.
   #define Kpspd    0.4125// 0.2// 1.2// 0.4125//   0.1125//0.03125//0.3125 //0.1125 //0.3125
         
   #define Kcorspd  0.007576// 0.019// 0.0032// 0.007576  // 0.0060 //0.06 //0.006

   #define KpCapVol	 1  // 0.07     // 0.7 is for open loop
   #define KiCapVol	0.008//  0.007	   //	0.01 is for open loop

   #define Rs1 0.668           // stator resistance  
   #define Rr1 0.50             //Rotor resistance, refer to stator side
   #define Lr1 0.1449           //Rotor inductance
   #define Lm1 0.141            //Magnetizing inductance
   #define Tr1 0.2898         //Rotor time constant Lr/Rr
   #define Ls1 0.1449           // Stator Inductance
   #define Q1   0.05310          // leakage coeeficient 1-Lm*Lm/Lr*Ls

   #define Rr3 0.32             //Rotor resistance, refer to stator side
   #define Lr3 0.0127           //Rotor inductance
   #define Lm3 0.0111           //Magnetizing inductance
   #define Tr3 0.0396875        //Rotor time constant Lr3/Rr3
   #define Ls3 0.014           // Stator Inductance
   #define Q3  0.3070          // leakage coeeficient 1-Lm3*Lm3/Lr3*Ls3
   #define FluxBand 0.005
   #define TorqueBand 0.5
   #define k1         200
   #define k2		  200


   #define Amplitude 0.525648936*Vdc*0.75
   #define MAX_PWM_CHANNELS 15
   #define K                1.618033989          // (1+sqrt(5))/2
   #define Factor_K1        1.809016994*2      //(5+sqrt(5))/4
   #define Factor_K2        0.587785252*2     //  sqrt(10-2*sqrt(5))/4
   #define Factor_K3        0.690983005*2    //    (5-sqrt(5))/4
   #define Factor_K4        0.951056516*2   //  sqrt(10+2*sqrt(5))/4
   #define Factor_K5        1.118033989*2   //     sqrt(5)/2
   #define Factor_K6        1.538841769*2  //  (sqrt(10+2*sqrt(5))+sqrt(10-2*sqrt(5)))/4
   #define Factor_K7        0.363271264*2  //  (sqrt(10+2*sqrt(5))-sqrt(10-2*sqrt(5)))/4
   #define VoltageRef		0
  
//void InitPWM(void);

void InitPWM(void);

void SetPwmMod(ushort Channel,unsigned int PWM_Signal);
void ResetPWM (unsigned int PWM_Sig[]);
void StopPwmMod(ushort Channel);
int PWMWidth_Cal(int Value_a,float DutyRatio,float Vdc,float Vdse, float Vqse, float RotorFluxAng, float Ia, float Ib,float Ic,float Id,float Ie, unsigned int SwitchState[], unsigned int PWM_Width[]);
void PWMWidthCalCulationForAuxiliary (int Value_Aux,float Vdc,unsigned int PWM_Width_Aux[]); 
void ADC0_Wait(void);
void delay (void);
void DagitAnalogConversion (unsigned short int OutputChannel, unsigned short int DigtalData); 
void fill_sine_wave_table( float sine_wave[]);
int state_transition (void);
int SetPwmModulation(ushort Channel, unsigned int IGBT_State, unsigned int SetTimer, unsigned int ResetTimer);
void PWMWidthLimitation(float Ia, float Ib, float Ic, float Id, float Ie,unsigned int OriginalPWMWidth[], unsigned int SetTimer[], unsigned int ResetTimer[]);
void AnalogToDigitConversion(int OffSet[7]);
void PI_Controller(int SpdCNT,float SpdRef,float Vdc, float RotorSpd, float Idse,float Iqse, float Vdqse[]);
float RotorFluxSlipAngleCal(float Idse,float Iqse, float RotorFluxAng, float StatorFluxPara[]);
float RotorFluxAngleCal(int RotorPos, int RotorPosInit,float SlipRingAng);
float SpeedCalculation (int RotorPos, int RotorPosPre);
float DCLinkMeasurement(int ActualCapVol);
int ClassicDTCPwmModulation(ushort Channel, unsigned int IGBT_State,float PhaseCurrent);
void SlidingModeFluxObserver(float RotorSpeed, float Idss, float Iqss,float Vdss, float Vqss, float CurrentAndFlux[4]);
void DTCLookUpTable (float TorErr, float FlxErr,float RotorSpeed,float StatorFluxAng_F, float StatorFluxAng_A, float StatorFuxMagnitude, float Vdc, float Vdq[4],unsigned int IGBTState[5]);
void SMOParameterIni_F(void);
void SlidingModeFluxObserver_A(float RotorSpeed,float Id3ss, float Iq3ss, float Vd3ss, float Vq3ss, float CurrentAndFlux3[4]);
void SMOParameterIni_A(void);
void DTCLookUpTableWithNPCompensation (float Ia,float Ib, float Ic, float Id, float Ie,unsigned int HysteresisStatus,float TorErr, float FlxErr,float RotorSpeed,float StatorFluxAng_F, float StatorFluxAng_A, float StatorFuxMagnitude, float Vdc,float Vdq[4], unsigned int IGBTState[5]);
int DTCLookUpTable3WithNPBalance (float Ia,float Ib, float Ic, float Id, float Ie,unsigned int HysteresisStatus,float TorErr, float FlxErr,float RotorSpeed,float StatorFluxAng_F, float StatorFluxAng_A, float StatorFuxMagnitude, float Vdc,float Vdq[4], unsigned int IGBTState[5],unsigned int NPImbalance);
void DTCLookupTable_2level(float Ia,float Ib, float Ic, float Id, float Ie,float TorErr, float FlxErr,float RotorSpeed,float StatorFluxAng_F, float StatorFluxAng_A, float StatorFuxMagnitude, float Vdc,float Vdq[4], unsigned int IGBTState[5]);
void InitPWM_2level(void);
int ClassicDTCPwmModulation_2level(ushort Channel, unsigned int IGBT_State, float PhaseCurrent);

void DTCLookupTableWith3HysteresisBand_2level(float Ia,float Ib, float Ic, float Id, float Ie,float TorErr, float FlxErr,float RotorSpeed,float StatorFluxAng_F, float StatorFluxAng_A, float StatorFuxMagnitude, float Vdc,float Vdq[4], unsigned int IGBTState[5]);







